/*
 * Decompiled with CFR 0.152.
 */
package music;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.sound.sampled.AudioFileFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.filechooser.FileFilter;
import javazoom.jl.converter.Converter;
import javazoom.jl.decoder.JavaLayerException;
import music.Main;
import music.commonUtils;
import music.gameCanvas;
import music.musicScore;
import music.settings;

public class songConverter
extends JLabel {
    private static final long serialVersionUID = 400L;
    private static String inFileName = "";
    private static File inFile = null;
    private static String outFileName = "";
    private static final boolean debug = false;
    private static String error = "";
    private static boolean isRunning = true;
    private static int midiSize;
    private static int count;
    private static String[] sharpNotes;
    private static String[] flatNotes;
    private JProgressBar progress = new JProgressBar();
    private JFrame progressBarFrame;
    private static JFrame parent;
    private static double maxRL;
    private static double minRL;
    private static double maxNL;
    private static double minNL;
    private static final boolean mp3wavCapability;
    public static final int pixelsPerSecond = 40;

    public static boolean initializeVars() {
        isRunning = true;
        try {
            maxRL = songConverter.stringToDouble(settings.maxRestLength);
            minRL = songConverter.stringToDouble(settings.minRestLength);
            maxNL = songConverter.stringToDouble(settings.maxNoteLength);
            minNL = songConverter.stringToDouble(settings.minNoteLength);
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public boolean convertSong(JFrame frameParent, int width, int height) {
        block10: {
            songConverter.initializeVars();
            parent = frameParent;
            JFileChooser chooser = new JFileChooser();
            chooser.setSize(width, height);
            chooser.setFileFilter(new FileFilter(){

                public boolean accept(File f) {
                    if (f.isDirectory()) {
                        return true;
                    }
                    String n = f.getName().toLowerCase();
                    if (n.endsWith(".mid")) {
                        return true;
                    }
                    if (n.endsWith(".midi")) {
                        return true;
                    }
                    if (n.endsWith(".au")) {
                        return true;
                    }
                    if (n.endsWith(".aiff")) {
                        return true;
                    }
                    if (n.endsWith(".aif")) {
                        return true;
                    }
                    if (mp3wavCapability) {
                        if (n.endsWith(".mp3")) {
                            return true;
                        }
                        if (n.endsWith(".wav")) {
                            return true;
                        }
                    }
                    return false;
                }

                public String getDescription() {
                    return "Music Files";
                }
            });
            chooser.setCurrentDirectory(Main.directory);
            switch (chooser.showDialog(parent, "Choose Song to Convert")) {
                case 0: {
                    inFileName = chooser.getSelectedFile().getName();
                    outFileName = songConverter.defaultOut(inFileName);
                    inFile = chooser.getSelectedFile();
                    break;
                }
                case -1: 
                case 1: {
                    return false;
                }
            }
            if (inFile.getName().toLowerCase().endsWith(".mp3")) {
                inFile = this.mp3ToWav(inFile);
            }
            if (inFile.getName().toLowerCase().endsWith(".aiff") || inFile.getName().toLowerCase().endsWith(".aif") || inFile.getName().toLowerCase().endsWith(".au")) {
                inFile = this.AiffAuToWav(inFile);
            }
            try {
                Main.song.changeTrack(inFile.getCanonicalPath());
            }
            catch (IOException ex) {
                if (!Main.debugErrors) break block10;
                System.out.println(ex);
            }
        }
        this.progress = new JProgressBar(0, 10);
        this.progress.setPreferredSize(new Dimension(250, 20));
        this.progress.setValue(0);
        String fileName = inFile.getName();
        if (inFile.getName().contains(".")) {
            fileName = inFile.getName().substring(0, inFile.getName().indexOf("."));
        }
        this.progressBarFrame = new JFrame("Converting " + fileName);
        this.progressBarFrame.setIconImage(Main.imgIcon);
        this.progressBarFrame.add(this.progress);
        this.progressBarFrame.setDefaultCloseOperation(2);
        this.progressBarFrame.setSize(500, 100);
        this.progressBarFrame.setVisible(true);
        this.progressBarFrame.pack();
        this.progressBarFrame.setLocationRelativeTo(parent);
        this.progressBarFrame.addWindowListener(new WindowListener(){

            public void windowClosed(WindowEvent e) {
            }

            public void windowOpened(WindowEvent e) {
            }

            public void windowClosing(WindowEvent e) {
                block4: {
                    isRunning = false;
                    if (songConverter.this.progress.getValue() == songConverter.this.progress.getMaximum()) {
                        songConverter.this.setSuccess(true);
                    } else {
                        songConverter.this.setSuccess(false);
                    }
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException Ie) {
                        if (!Main.debugErrors) break block4;
                        System.out.println(Ie);
                    }
                }
                songConverter.this.reset();
            }

            public void windowDeiconified(WindowEvent e) {
            }

            public void windowActivated(WindowEvent e) {
            }

            public void windowDeactivated(WindowEvent e) {
            }

            public void windowIconified(WindowEvent e) {
            }
        });
        if (inFile.getName().toLowerCase().endsWith(".wav")) {
            new Thread((Runnable)new WAVConverterThread(), "MIDI Decoder").start();
            return true;
        }
        new Thread((Runnable)new MIDIConverterThread(), "MIDI Decoder").start();
        return true;
    }

    public void reset() {
        this.progress.setEnabled(false);
        this.progress.setVisible(false);
        this.progress = null;
        if (this.progressBarFrame != null) {
            this.progressBarFrame.dispose();
        }
        inFileName = "";
        outFileName = "";
        error = "";
        midiSize = 0;
        count = 0;
        this.progress = new JProgressBar();
        inFile = null;
    }

    private void setSuccess(boolean b) {
        if (b) {
            Rectangle bounds = this.getBounds();
            bounds.width = 530;
            this.setBounds(bounds);
            this.setText("<html><font color='#000000'>Success! Convert your Music</font>");
        } else {
            Rectangle bounds = this.getBounds();
            bounds.width = 380;
            this.setBounds(bounds);
            this.setText("<html><font color='#000000'>Convert your Music</font>");
        }
    }

    private static void midiError(String e) {
        if (isRunning) {
            error = "Canceled";
            return;
        }
        isRunning = false;
        if (Main.debugErrors) {
            System.out.println(error);
        }
        JOptionPane.showMessageDialog(parent, "Error parsing MIDI file: " + e, "Sorry", 0, Main.icoIcon);
    }

    private static String defaultOut(String input) {
        if (input.length() <= 3) {
            return "";
        }
        try {
            return "scores" + File.separator + input.substring(0, input.length() - 3).concat("txt");
        }
        catch (Exception e) {
            new File("scores").mkdir();
            return songConverter.defaultOut(input);
        }
    }

    public static double stringToDouble(String string) throws Exception {
        StringTokenizer s = new StringTokenizer(string, "/");
        int tokenCount = s.countTokens();
        if (tokenCount != 2) {
            return Integer.parseInt(string);
        }
        String[] fraction = new String[tokenCount];
        for (int i = 0; i < tokenCount; ++i) {
            fraction[i] = s.nextToken();
        }
        return (float)Integer.parseInt(fraction[0]) / (float)Integer.parseInt(fraction[1]);
    }

    private File mp3ToWav(File songFile) {
        String newName;
        block2: {
            newName = songFile.toString();
            newName = newName.substring(0, newName.indexOf(".")) + ".wav";
            Converter myconvert = new Converter();
            try {
                myconvert.convert(songFile.toString(), newName);
            }
            catch (JavaLayerException ex) {
                if (!Main.debugErrors) break block2;
                System.out.println(ex);
            }
        }
        File wav = new File(newName);
        return wav;
    }

    private File AiffAuToWav(File inFile) {
        String inputPath = inFile.getName();
        File outFile = new File(inputPath.substring(0, inputPath.indexOf(".")) + ".wav");
        try {
            AudioFileFormat inFileFormat = AudioSystem.getAudioFileFormat(inFile);
            if (inFileFormat.getType() != AudioFileFormat.Type.WAVE) {
                AudioInputStream inFileAIS = AudioSystem.getAudioInputStream(inFile);
                inFileAIS.reset();
                if (AudioSystem.isFileTypeSupported(AudioFileFormat.Type.WAVE, inFileAIS)) {
                    AudioSystem.write(inFileAIS, AudioFileFormat.Type.WAVE, outFile);
                    inFileAIS.close();
                    return outFile;
                }
                String er = "AIFF conversion of " + inFile.getPath() + " is not currently supported by AudioSystem.";
                if (Main.debugErrors) {
                    System.out.println(er);
                }
                JOptionPane.showMessageDialog(parent, er, "Error!", 1, Main.icoIcon);
            }
        }
        catch (IOException e) {
            String er = "Could not input " + inFile.getPath() + "!";
            if (Main.debugErrors) {
                System.out.println(er + " " + e);
            }
            JOptionPane.showMessageDialog(parent, er, "Whoops!", 1, Main.icoIcon);
        }
        catch (Exception e) {
            String er = inFile.getPath() + " is not a supported audio file type!";
            if (Main.debugErrors) {
                System.out.println(er + " " + e);
            }
            JOptionPane.showMessageDialog(parent, er, "Whoops!", 1, Main.icoIcon);
        }
        return null;
    }

    private boolean generateScoreFromWav(File inFile) {
        Graphics progressGraphics;
        int[] dist;
        int width;
        boolean debug_function;
        block27: {
            debug_function = false;
            double trackLength = this.length(inFile);
            if (trackLength < 6.0) {
                JOptionPane.showMessageDialog(parent, "Song must be more than 6 seconds long!", "Sorry!", 1, Main.icoIcon);
                return false;
            }
            width = (int)(trackLength * 40.0);
            if (width == 501) {
                ++width;
            }
            dist = null;
            String distances = "";
            progressGraphics = this.progress.getGraphics();
            try {
                this.progress.setMaximum(200);
                this.progress.setString("Analyzing Song Waveform");
                this.progress.setValue(1);
                this.progress.update(progressGraphics);
                String sys = System.getProperty("os.name");
                Process p = null;
                if (sys.startsWith("Windows")) {
                    p = Runtime.getRuntime().exec(Main.directory + File.separator + "Python" + File.separator + "winDist" + File.separator + "wav2png.exe -h 501 -w " + width + ' ' + '\"' + inFile.getPath() + '\"');
                } else if (sys.startsWith("Mac")) {
                    p = Runtime.getRuntime().exec("open -a " + Main.directory + File.separator + "Python" + File.separator + "macDist" + File.separator + "wav2png.app -h 501 -w " + width + ' ' + '\"' + inFile.getPath() + '\"');
                }
                InputStream pythonOutput = p.getInputStream();
                int brackets = 0;
                String prog = "";
                while (isRunning) {
                    try {
                        p.exitValue();
                        break;
                    }
                    catch (Exception e) {
                        int input = pythonOutput.read();
                        if (input == 91) {
                            ++brackets;
                        } else if (input == 93) {
                            --brackets;
                        } else if (brackets > 0 && input != 44) {
                            distances = distances + (char)input;
                        } else if ((char)input != '%') {
                            prog = prog + (char)input;
                        } else {
                            try {
                                this.progress.setValue(Integer.parseInt(prog.substring(1)));
                                this.progress.update(progressGraphics);
                            }
                            catch (Exception e2) {
                                // empty catch block
                            }
                            prog = "";
                        }
                        if (debug_function) {
                            System.out.print((char)input);
                        }
                        commonUtils.sleep(5);
                    }
                }
                if (!isRunning) {
                    p.destroy();
                    return false;
                }
                Thread.sleep(100L);
                System.out.println(distances);
                String[] distL = distances.split(" ");
                dist = new int[distL.length];
                for (int c = 0; c < dist.length; ++c) {
                    try {
                        dist[c] = Integer.parseInt(distL[c]);
                        continue;
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
            }
            catch (IOException ex) {
                if (debug_function) {
                    System.out.println(ex);
                }
            }
            catch (InterruptedException ex) {
                if (!debug_function) break block27;
                System.out.println(ex);
            }
        }
        this.progress.setValue(150);
        this.progress.update(progressGraphics);
        amplitudeFile file = new amplitudeFile("spectrum.txt", width);
        return this.analyzeAndMakeScore(file, debug_function, progressGraphics, dist);
    }

    private boolean analyzeAndMakeScore(amplitudeFile file, boolean debug, Graphics g, int[] bpm) {
        int costToSwitch = 35;
        ArrayList<byte[]> probData = new ArrayList<byte[]>(file.size + 10);
        while (file.hasMoreData() && isRunning) {
            double[] spectrum = file.readLine();
            byte[] data = this.noteProbability(spectrum);
            probData.add(data);
            if (!debug) continue;
            commonUtils.printArray(data, 4);
        }
        file.close();
        if (!isRunning) {
            return false;
        }
        this.progress.setValue(160);
        this.progress.update(g);
        byte[][] probs = commonUtils.byteArrayListToArray(probData);
        byte[][] pointer = new byte[probs.length][probs[0].length];
        int[][] table = new int[probs.length][probs[0].length];
        for (int y = 11; y >= 0; y = (int)((byte)(y - 1))) {
            table[0][y] = probs[0][y];
            pointer[0][y] = -1;
        }
        for (int x = 1; x < table.length; ++x) {
            for (int y = 11; y >= 0; y = (int)((byte)(y - 1))) {
                int maxScore = Integer.MIN_VALUE;
                int maxIndex = -1;
                for (int z = 11; z >= 0; z = (int)((byte)(z - 1))) {
                    int score = probs[x][y] + table[x - 1][z];
                    if (y != z) {
                        score -= costToSwitch;
                    }
                    if (score <= maxScore) continue;
                    maxScore = score;
                    maxIndex = z;
                }
                table[x][y] = maxScore;
                pointer[x][y] = maxIndex;
            }
        }
        if (!isRunning) {
            return false;
        }
        this.progress.setValue(190);
        this.progress.update(g);
        int maxScore = Integer.MIN_VALUE;
        int maxIndex = -1;
        for (int y = 11; y >= 0; y = (int)((byte)(y - 1))) {
            if (table[table.length - 1][y] <= maxScore) continue;
            maxScore = table[table.length - 1][y];
            maxIndex = y;
        }
        byte[] notes = new byte[table.length];
        notes[notes.length - 1] = maxIndex;
        for (int x = notes.length - 2; x >= 0; --x) {
            notes[x] = pointer[x + 1][notes[x + 1]];
        }
        commonUtils.printArray(notes);
        int[] load = this.combineNotes(notes);
        musicScore s = new musicScore();
        int beatCount = 0;
        for (int x = 0; x < bpm.length; ++x) {
            if (x % 2 == 0) {
                s.appendBPM((int)(2400.0 / (double)bpm[x]));
                continue;
            }
            if (x == 1) {
                beatCount = (int)((float)beatCount + (float)bpm[x] / (float)bpm[x - 1]);
                continue;
            }
            s.appendBPM(beatCount);
            beatCount = (int)((float)beatCount + (float)bpm[x] / (float)bpm[x - 1]);
        }
        if (!isRunning) {
            return false;
        }
        this.setSuccess(true);
        s.loadIntArray(load);
        s.simplifyTrack();
        s.writeFile(outFileName);
        this.reset();
        return true;
    }

    private int[] combineNotes(byte[] notes) {
        ArrayList<Integer> v = new ArrayList<Integer>(notes.length / 20);
        byte lastNote = notes[0];
        int lastLength = 1;
        for (int x = 1; x < notes.length; ++x) {
            if (notes[x] != lastNote) {
                v.add(Integer.valueOf(lastNote));
                v.add(lastLength);
                lastNote = notes[x];
                lastLength = 1;
                continue;
            }
            ++lastLength;
        }
        v.add(Integer.valueOf(lastNote));
        v.add(lastLength);
        return commonUtils.integerArrayListToArray(v);
    }

    private byte[] noteProbability(double[] spectrum) {
        int x;
        double[] prob = new double[12];
        short[] ct = new short[12];
        for (x = spectrum.length - 1; x >= 0; --x) {
            int note;
            if (x <= 20 || x >= 100) continue;
            int n = note = songConverter.returnNote(23.34 * (double)x + 2.9846);
            prob[n] = prob[n] + spectrum[x];
            int n2 = note;
            ct[n2] = (short)(ct[n2] + 1);
        }
        for (x = prob.length - 1; x >= 0; --x) {
            int n = x;
            prob[n] = prob[n] * (double)(100 / ct[x]);
        }
        return commonUtils.toByteArray(commonUtils.standardize(prob));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private double length(File f) {
        int bytesPerSecond;
        int fileSize;
        block11: {
            FileInputStream file = null;
            fileSize = 0;
            bytesPerSecond = 0;
            try {
                file = new FileInputStream(f);
                DataInputStream dis = new DataInputStream(file);
                try {
                    for (int i = 0; i <= 31; ++i) {
                        int input = dis.readByte();
                        if (input < 0) {
                            input += 256;
                        }
                        if (i >= 4 && i <= 7) {
                            fileSize = (int)((double)fileSize + (double)input * Math.pow(256.0, i - 4));
                            continue;
                        }
                        if (i < 28 || i > 31) continue;
                        bytesPerSecond = (int)((double)bytesPerSecond + (double)input * Math.pow(256.0, i - 28));
                    }
                }
                catch (Exception e) {
                    if (Main.debugErrors) {
                        songConverter.midiError("Error in wav parsing: " + e);
                    }
                }
                finally {
                    dis.close();
                    file.close();
                }
            }
            catch (Exception e) {
                if (!Main.debugErrors) break block11;
                songConverter.midiError("File not found: " + e);
            }
        }
        return (float)fileSize / (float)bytesPerSecond;
    }

    private static int returnNote(double highfrequency) {
        while (highfrequency > 100.88) {
            highfrequency /= 2.0;
        }
        while (highfrequency <= 50.44) {
            highfrequency *= 2.0;
        }
        if (highfrequency > 95.25) {
            return 10;
        }
        if (highfrequency > 89.905) {
            return 9;
        }
        if (highfrequency > 84.86) {
            return 8;
        }
        if (highfrequency > 80.1) {
            return 7;
        }
        if (highfrequency > 75.6) {
            return 6;
        }
        if (highfrequency > 71.5) {
            return 5;
        }
        if (highfrequency > 67.355) {
            return 4;
        }
        if (highfrequency > 63.56) {
            return 3;
        }
        if (highfrequency > 60.0) {
            return 2;
        }
        if (highfrequency > 56.635) {
            return 1;
        }
        if (highfrequency > 53.45) {
            return 0;
        }
        if (highfrequency > 50.44) {
            return 11;
        }
        return -1;
    }

    static {
        count = 0;
        sharpNotes = new String[]{"C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B"};
        flatNotes = new String[]{"C", "Db", "D", "Eb", "E", "F", "Gb", "G", "Ab", "A", "Bb", "B"};
        maxRL = 0.0;
        minRL = 0.0;
        maxNL = 0.0;
        minNL = 0.0;
        mp3wavCapability = System.getProperty("os.name").startsWith("Windows");
    }

    private class amplitudeFile {
        private DataInputStream dis;
        private int size;

        private amplitudeFile(String f) {
            block2: {
                this.dis = null;
                try {
                    this.dis = new DataInputStream(new FileInputStream(f));
                }
                catch (FileNotFoundException ex) {
                    if (!Main.debugErrors) break block2;
                    System.out.println(ex);
                }
            }
        }

        private amplitudeFile(String f, int size) {
            this(f);
            this.size = size;
        }

        private double[] readLine() {
            double[] line;
            block5: {
                line = new double[1025];
                try {
                    int xx;
                    for (xx = 0; xx < line.length; ++xx) {
                        int IN = this.dis.readByte();
                        if (IN < 0) {
                            IN += 256;
                        }
                        line[xx] = (double)IN / 255.0;
                    }
                    for (xx = 0; xx <= 3; ++xx) {
                        this.dis.readByte();
                    }
                }
                catch (IOException iOException) {
                    if (!Main.debugErrors) break block5;
                    System.out.println(iOException);
                }
            }
            return line;
        }

        private boolean hasMoreData() {
            try {
                return this.dis.available() > 0;
            }
            catch (IOException e) {
                if (Main.debugErrors) {
                    System.out.println(e + " in hasMoreData function.");
                }
                return false;
            }
        }

        private void close() {
            block2: {
                try {
                    this.dis.close();
                }
                catch (IOException ex) {
                    if (!Main.debugErrors) break block2;
                    System.out.println(ex);
                }
            }
        }
    }

    private class MIDIConverterThread
    implements Runnable {
        private Graphics progressGraphics = null;
        private StringBuffer currentTrack;

        MIDIConverterThread() {
            isRunning = true;
            this.progressGraphics = songConverter.this.progress.getGraphics();
        }

        public void run() {
            int BPM = 0;
            ArrayList<Integer> BPMarray = new ArrayList<Integer>();
            int midiType = -1;
            int numTracks = -1;
            int ticksPerBeat = -1;
            int framesPerSecond = -1;
            int ticksPerFrame = -1;
            int notePlaying = -1;
            Double notePlayingTime = 0.0;
            Double sysTime = 0.0;
            int noteVelocity = 0;
            Double lastNoteEndTime = 0.0;
            boolean sharps = true;
            String[] allTracks = null;
            String[] trackInstruments = null;
            int[] channelInst = new int[16];
            int lastNoteInst = 127;
            count = 0;
            String[] store = this.readFile(inFile);
            if (!(store[count++].equals("4d") && store[count++].equals("54") && store[count++].equals("68") && store[count++].equals("64"))) {
                error = "Header did not start with MThd - not a midi file.";
                songConverter.midiError(error);
                return;
            }
            if (!(store[count++].equals("00") && store[count++].equals("00") && store[count++].equals("00") && store[count++].equals("06"))) {
                error = "Improperly-sized header.";
                songConverter.midiError(error);
                return;
            }
            if (!store[count++].equals("00")) {
                error = "Error reading MIDI Type!";
                songConverter.midiError(error);
                return;
            }
            midiType = Integer.parseInt(store[count++], 16);
            numTracks = Integer.parseInt(store[count++], 16) * 256 + Integer.parseInt(store[count++], 16);
            String Byte1 = this.int2bin(Integer.parseInt(store[count++], 16));
            String Byte2 = this.int2bin(Integer.parseInt(store[count++], 16));
            if (Byte1.charAt(0) == '0') {
                ticksPerBeat = Integer.parseInt(Byte1.substring(1, 8).concat(Byte2), 2);
            } else {
                framesPerSecond = Integer.parseInt(Byte1.substring(1, 8), 2);
                ticksPerFrame = Integer.parseInt(Byte2, 2);
            }
            for (int track = 1; track <= numTracks; ++track) {
                if (!isRunning) {
                    error = "Canceled";
                    return;
                }
                this.currentTrack = new StringBuffer();
                while (!store[count++].equals("4d")) {
                    if (count <= midiSize) continue;
                    return;
                }
                if (!(store[count++].equals("54") && store[count++].equals("72") && store[count++].equals("6b"))) {
                    error = "Track data marker did not appear 'MTrk'.";
                    songConverter.midiError(error);
                    break;
                }
                int numBytes = Integer.parseInt(store[count++].concat(store[count++]).concat(store[count++]).concat(store[count++]), 16);
                int stop = numBytes + count - 4;
                while (count <= stop && isRunning) {
                    int time;
                    if (count % 50 == 0) {
                        songConverter.this.progress.setValue(count);
                        songConverter.this.progress.update(this.progressGraphics);
                    }
                    try {
                        Thread.sleep(0L, 100);
                    }
                    catch (InterruptedException ex) {
                        // empty catch block
                    }
                    if (Integer.parseInt(store[count], 16) > 127) {
                        int n1 = Integer.parseInt(store[count], 16);
                        ++count;
                        if (Integer.parseInt(store[count], 16) > 127) {
                            int n2 = Integer.parseInt(store[count], 16);
                            ++count;
                            if (Integer.parseInt(store[count], 16) > 127) {
                                int n3 = Integer.parseInt(store[count], 16);
                                ++count;
                                time = this.midiDecTime2normalTime(new int[]{n1, n2, n3, Integer.parseInt(store[count++], 16)});
                            } else {
                                time = this.midiDecTime2normalTime(new int[]{n1, n2, Integer.parseInt(store[count++], 16)});
                            }
                        } else {
                            time = this.midiDecTime2normalTime(new int[]{n1, Integer.parseInt(store[count++], 16)});
                        }
                    } else {
                        time = this.midiDecTime2normalTime(new int[]{Integer.parseInt(store[count++], 16)});
                    }
                    Double deltaTime = time != 0 && ticksPerBeat != -1 ? Double.valueOf((double)time / (double)ticksPerBeat) : Double.valueOf(time);
                    sysTime = sysTime + deltaTime;
                    String actionByte = store[count++];
                    block2 : switch (actionByte.charAt(0)) {
                        case '8': {
                            int noteNum = Integer.parseInt(store[count++], 16);
                            int velocity = Integer.parseInt(store[count++], 16);
                            int chan = Integer.parseInt(String.valueOf(actionByte.charAt(1)), 16);
                            if (notePlaying == -1 || noteNum != notePlaying) break;
                            this.addNote(sysTime, notePlayingTime, notePlaying, sharps);
                            notePlaying = -1;
                            noteVelocity = 0;
                            lastNoteEndTime = sysTime;
                            lastNoteInst = -1;
                            break;
                        }
                        case '9': {
                            int noteNum = Integer.parseInt(store[count++], 16);
                            int chan = Integer.parseInt(String.valueOf(actionByte.charAt(1)), 16);
                            int velocity = Integer.parseInt(store[count++], 16);
                            if (notePlaying == -1) {
                                this.addRest(sysTime, lastNoteEndTime);
                                lastNoteEndTime = sysTime;
                                if (chan == 9) break;
                                notePlaying = noteNum;
                                notePlayingTime = sysTime;
                                noteVelocity = velocity;
                                lastNoteInst = channelInst[chan];
                                break;
                            }
                            if (velocity == 0) {
                                if (noteNum != notePlaying) break;
                                this.addNote(sysTime, notePlayingTime, notePlaying, sharps);
                                notePlaying = -1;
                                noteVelocity = 0;
                                lastNoteEndTime = sysTime;
                                lastNoteInst = -1;
                                break;
                            }
                            if (!this.getFitness(noteNum, notePlaying, velocity, noteVelocity, channelInst[chan], lastNoteInst)) break;
                            this.addNote(sysTime, notePlayingTime, notePlaying, sharps);
                            notePlaying = noteNum;
                            notePlayingTime = sysTime;
                            noteVelocity = velocity;
                            lastNoteInst = channelInst[chan];
                            break;
                        }
                        case 'a': {
                            int note = Integer.parseInt(store[count++], 16);
                            int chan = Integer.parseInt(String.valueOf(actionByte.charAt(1)), 16);
                            int v = Integer.parseInt(store[count++], 16);
                            break;
                        }
                        case 'b': {
                            int chan = Integer.parseInt(String.valueOf(actionByte.charAt(1)), 16);
                            int type = Integer.parseInt(store[count++], 16);
                            int val = Integer.parseInt(store[count++], 16);
                            break;
                        }
                        case 'c': {
                            int chan = Integer.parseInt(String.valueOf(actionByte.charAt(1)), 16);
                            int num = Integer.parseInt(store[count++], 16);
                            String[] inst = this.getInstrument(num);
                            channelInst[chan] = num;
                            break;
                        }
                        case 'd': {
                            int chan = Integer.parseInt(String.valueOf(actionByte.charAt(1)), 16);
                            int amount = Integer.parseInt(store[count++], 16);
                            break;
                        }
                        case 'e': {
                            int chan = Integer.parseInt(String.valueOf(actionByte.charAt(1)), 16);
                            int pitchBend = Integer.parseInt(store[count++], 16) * Integer.parseInt(store[count++], 16) - 8192;
                            break;
                        }
                        case 'f': {
                            if (actionByte.charAt(1) == 'f') {
                                switch (Integer.parseInt(store[count++], 16)) {
                                    case 0: {
                                        int skip = Integer.parseInt(store[count++], 16);
                                        if (skip != 2) {
                                            // empty if block
                                        }
                                        count += skip;
                                        break block2;
                                    }
                                    case 1: 
                                    case 2: 
                                    case 3: 
                                    case 4: {
                                        int skip;
                                        String instrumentName = "";
                                        for (int nn = skip = Integer.parseInt(store[count++], 16); nn > 0; --nn) {
                                            instrumentName = instrumentName.concat(store[count++]);
                                        }
                                        instrumentName = this.decodeHexString(instrumentName);
                                        if (trackInstruments == null) {
                                            trackInstruments = new String[numTracks];
                                        }
                                        trackInstruments[track - 1] = instrumentName;
                                        break block2;
                                    }
                                    case 5: 
                                    case 6: 
                                    case 7: {
                                        int skip = Integer.parseInt(store[count++], 16);
                                        count += skip;
                                        break block2;
                                    }
                                    case 47: {
                                        if (store[count++].equals("00")) break block2;
                                        error = "Track header did not end at the appropriate time.  Error in byte " + count;
                                        songConverter.midiError(error);
                                        break block2;
                                    }
                                    case 81: {
                                        int skip = Integer.parseInt(store[count++], 16);
                                        if (skip != 3) {
                                            // empty if block
                                        }
                                        BPM = 60000000 / Integer.parseInt(store[count++].concat(store[count++]).concat(store[count++]), 16);
                                        BPMarray.add(BPM);
                                        BPMarray.add(sysTime.intValue());
                                        if (ticksPerBeat != -1) break block2;
                                        ticksPerBeat = ticksPerFrame * framesPerSecond / (60 * BPM);
                                        break block2;
                                    }
                                    case 88: {
                                        if (Integer.parseInt(store[count++], 16) != 4) {
                                            // empty if block
                                        }
                                        count += 4;
                                        break block2;
                                    }
                                    case 89: {
                                        if (Integer.parseInt(store[count++], 16) != 2) {
                                            // empty if block
                                        }
                                        int numSharps = Integer.parseInt(store[count++], 16);
                                        ++count;
                                        if (numSharps <= 7) {
                                            sharps = true;
                                            break block2;
                                        }
                                        if (numSharps < 249) break block2;
                                        numSharps -= 256;
                                        sharps = false;
                                        break block2;
                                    }
                                }
                                int skip = Integer.parseInt(store[count++], 16);
                                count += skip;
                                break;
                            }
                            error = "Error in action byte; byte number " + count + ".";
                            songConverter.midiError(error);
                            break;
                        }
                    }
                }
                if (trackInstruments != null) {
                    // empty if block
                }
                if (allTracks == null) {
                    allTracks = new String[numTracks];
                }
                allTracks[track - 1] = this.currentTrack.toString();
                this.currentTrack = new StringBuffer();
                if (trackInstruments != null) continue;
                trackInstruments = this.initialize(numTracks);
            }
            if (!isRunning) {
                return;
            }
            try {
                isRunning = false;
                Thread.sleep(50L);
                int index = this.chooseTrack(trackInstruments, allTracks);
                if (index == -1) {
                    Rectangle bounds = songConverter.this.getBounds();
                    bounds.width = 550;
                    songConverter.this.setBounds(bounds);
                    songConverter.this.setText("<html><font color='#000000'>Canceled. Convert your Music</font>");
                    return;
                }
                musicScore score = this.buildTrack((String)allTracks[index]);
                score.loadMIDIBPM(BPMarray);
                score.simplifyTrack();
                score.writeFile(outFileName);
                songConverter.this.setSuccess(true);
                songConverter.this.reset();
            }
            catch (InterruptedException e) {
                // empty catch block
            }
        }

        private String decodeHexString(String hexText) {
            String decodedText = null;
            String chunk = null;
            if (hexText != null && hexText.length() > 0) {
                int numBytes = hexText.length() / 2;
                byte[] rawToByte = new byte[numBytes];
                int offset = 0;
                for (int i = 0; i < numBytes; ++i) {
                    chunk = hexText.substring(offset, offset + 2);
                    offset += 2;
                    rawToByte[i] = (byte)(Integer.parseInt(chunk, 16) & 0xFF);
                }
                decodedText = new String(rawToByte);
            }
            return decodedText;
        }

        private String[] readFile(File f) {
            StringBuffer sb = new StringBuffer();
            FileInputStream file = null;
            try {
                file = new FileInputStream(f);
                midiSize = file.available();
                if (songConverter.this.progress.getMaximum() == 10) {
                    songConverter.this.progress.setMaximum(midiSize);
                }
                DataInputStream dis = new DataInputStream(file);
                try {
                    while (true) {
                        int input;
                        if ((input = dis.readByte()) < 0) {
                            input += 256;
                        }
                        if (input < 16) {
                            sb.append("0");
                        }
                        sb.append(Integer.toHexString(input));
                    }
                }
                catch (Exception e) {
                    dis.close();
                    file.close();
                }
            }
            catch (Exception e) {
                songConverter.midiError("File not found: " + e);
            }
            String hexData = sb.toString();
            sb = null;
            String[] hexArray = new String[hexData.length() / 2];
            int i = 0;
            int s = hexData.length() / 2;
            while (i < s) {
                hexArray[i] = hexData.substring(2 * i, 2 * ++i);
            }
            return hexArray;
        }

        private String int2bin(int n) {
            String s = "";
            for (int y = 7; y > -1; --y) {
                s = s.concat(Integer.toString(n >> y & 1));
            }
            return s;
        }

        private int midiDecTime2normalTime(int[] n) {
            int l = n.length - 1;
            int t = 0;
            for (int i = 0; i < l; ++i) {
                t = (int)((double)t + (double)(n[i] - 128) * Math.pow(2.0, 7 * (l - i)));
            }
            return t += n[l];
        }

        private String[] initialize(int numTracks) {
            String[] tracks = new String[numTracks];
            for (int ii = numTracks - 1; ii >= 0; --ii) {
                tracks[ii] = "Track " + ii;
            }
            return tracks;
        }

        private boolean areNoNotes(String s) {
            String notes = "ABCDEFG";
            for (int xx = s.length() - 1; xx >= 0; --xx) {
                if (notes.indexOf(s.charAt(xx)) == -1) continue;
                return false;
            }
            return true;
        }

        private int chooseTrack(String[] track_instruments, String[] scores) {
            int[] track_value = new int[track_instruments.length];
            Object[] list = (String[])track_instruments.clone();
            for (int aa = track_value.length - 1; aa >= 0; --aa) {
                if (scores[aa].length() < 20 || this.areNoNotes(scores[aa])) {
                    track_value[aa] = 0;
                    continue;
                }
                String inst = track_instruments[aa].toLowerCase();
                int default_instrument = commonUtils.greatestCommonSubsequence(inst, Main.instList[settings.defaultInstrument].toLowerCase());
                int file_name = commonUtils.greatestCommonSubsequence(inst, inFileName.toLowerCase());
                int solo = commonUtils.greatestCommonSubsequence(inst, "solo");
                double[] track_data = this.scoreTrack(scores[aa]);
                double mean_pitch = track_data[0];
                double stdev_pitch = track_data[1];
                double mean_length = track_data[2];
                double stdev_length = track_data[3] / track_data[2];
                double mean_interval = track_data[4];
                double stdev_interval = track_data[5];
                double length = track_data[6];
                track_value[aa] = (int)((double)((default_instrument + file_name + solo) * 10 + 10) - Math.abs(68.0 - mean_pitch) / 3.0 + stdev_pitch / 2.0 + Math.abs(1.0 - mean_length) * 5.0 - Math.abs(1.3 - stdev_length) * 2.0 + 10.0 - (Math.abs(6.0 - mean_interval * 2.0) + 10.0 - Math.abs(5.5 - stdev_interval) * 2.0 + Math.sqrt(length) / 2.0));
            }
            for (int bb = 0; bb < track_value.length; ++bb) {
                int max = bb;
                for (int scan = bb + 1; scan < list.length; ++scan) {
                    if (track_value[scan] <= track_value[max]) continue;
                    max = scan;
                }
                int temp = track_value[max];
                track_value[max] = track_value[bb];
                track_value[bb] = temp;
                Object temp2 = list[bb];
                list[bb] = list[max];
                list[max] = temp2;
            }
            if (list.length == 1) {
                return 0;
            }
            String x = (String)JOptionPane.showInputDialog(parent, "Which track would you like to generate a song for?", "Track Selection", 3, Main.icoIcon, list, list[0]);
            if (x == null) {
                return -1;
            }
            int selection = commonUtils.indexOf(x, track_instruments);
            return selection;
        }

        private double[] scoreTrack(String t) {
            try {
                Integer.parseInt(t.substring(0, 2));
                t = t.substring(t.indexOf(" ") + 1);
            }
            catch (Exception e) {
                // empty catch block
            }
            String[] s = t.split(" ");
            int[] p = new int[s.length / 2];
            int rests = 0;
            double[] lengths = new double[s.length / 2];
            for (int x = s.length - 1; x >= 0; --x) {
                try {
                    if (x % 2 == 1) {
                        lengths[(x - 1) / 2] = songConverter.stringToDouble(s[x]);
                        continue;
                    }
                    int st = gameCanvas.stringtoMidi(s[x]);
                    if (st == -1) {
                        ++rests;
                    }
                    p[x / 2] = st;
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            int[] pitches = new int[p.length - rests];
            rests = 0;
            for (int aaa = 0; aaa < p.length; ++aaa) {
                if (p[aaa] == -1) {
                    ++rests;
                    continue;
                }
                pitches[aaa - rests] = p[aaa];
            }
            int[] intervals = new int[pitches.length - 1];
            for (int x = intervals.length - 1; x >= 0; --x) {
                intervals[x] = Math.abs(pitches[x + 1] - pitches[x]);
            }
            double mean_pitch = commonUtils.avg(pitches);
            double stdev_pitch = commonUtils.standardDev(pitches, mean_pitch);
            double mean_length = commonUtils.avg(lengths);
            double stdev_length = commonUtils.standardDev(lengths, mean_length);
            double mean_interval = commonUtils.avg(intervals);
            double stdev_interval = commonUtils.standardDev(intervals, mean_interval);
            return new double[]{mean_pitch, stdev_pitch, mean_length, stdev_length, mean_interval, stdev_interval, pitches.length};
        }

        private void addNote(double sysTime, double notePlayingTime, int noteNum, boolean sharps) {
            if (sysTime - notePlayingTime > minNL) {
                if (sysTime - notePlayingTime < maxNL) {
                    this.currentTrack.append(this.midiToString(noteNum, sharps)).append(" ").append(commonUtils.doubleToStringFraction(sysTime - notePlayingTime)).append(" ");
                } else {
                    double newTime = sysTime - notePlayingTime;
                    newTime = newTime % maxNL > minNL ? (newTime %= maxNL) : (newTime += newTime % maxNL);
                    this.currentTrack.append(this.midiToString(noteNum, sharps)).append(" ").append(commonUtils.doubleToStringFraction(newTime)).append(" ");
                }
            } else {
                this.currentTrack = this.addShortToOld(this.currentTrack, sysTime, notePlayingTime);
            }
        }

        private String midiToString(int midiNote, boolean useSharps) {
            if (useSharps) {
                return sharpNotes[midiNote % 12].concat(Integer.toString(midiNote / 12 - 1));
            }
            return flatNotes[midiNote % 12].concat(Integer.toString(midiNote / 12 - 1));
        }

        private void addRest(double sysTime, double lastNoteEndTime) {
            if (sysTime - lastNoteEndTime > minRL) {
                if (sysTime - lastNoteEndTime < maxRL) {
                    this.currentTrack.append("_ ").append(commonUtils.doubleToStringFraction(sysTime - lastNoteEndTime)).append(" ");
                } else {
                    double newTime = sysTime - lastNoteEndTime;
                    newTime = newTime % maxRL > minRL ? (newTime %= maxRL) : (newTime += newTime % maxRL);
                    this.currentTrack.append("_ ").append(commonUtils.doubleToStringFraction(newTime)).append(" ");
                }
            } else {
                this.currentTrack = this.addShortToOld(this.currentTrack, sysTime, lastNoteEndTime);
            }
        }

        private StringBuffer addShortToOld(StringBuffer currentTrack, Double sysTime, Double notePlayingTime) {
            block4: {
                String t = "";
                int count = currentTrack.length() - 2;
                while (count >= 0 && currentTrack.charAt(count) != ' ') {
                    t = currentTrack.charAt(count--) + t;
                }
                if (count == 0) {
                    return currentTrack;
                }
                try {
                    double x = songConverter.stringToDouble(t);
                    String asdf = currentTrack.substring(0, count + 1);
                    currentTrack = new StringBuffer();
                    currentTrack.append(asdf).append(commonUtils.doubleToStringFraction(x + sysTime - notePlayingTime)).append(" ");
                }
                catch (Exception ex) {
                    if (!Main.debugErrors) break block4;
                    System.out.println(ex);
                }
            }
            return currentTrack;
        }

        private musicScore buildTrack(String trk) {
            musicScore newScore = new musicScore();
            newScore.loadText(trk);
            newScore.countScoreToTimeScore();
            newScore.concertAndDisplayTranspose(0, 0);
            String[] range = newScore.range();
            Object[] list = commonUtils.rangeObj(-20, 21);
            Object tpose = JOptionPane.showInputDialog(parent, "Current range is from " + range[0] + " to " + range[1] + ".  How much would you like to transpose?", "Track Generation", 3, Main.icoIcon, list, list[20]);
            newScore.concertAndDisplayTranspose(Integer.parseInt(tpose.toString()), 0);
            return newScore;
        }

        private boolean getFitness(int newNote, int oldNote, int newV, int oldV, int newInst, int oldInst) {
            String[] newInstStr = this.getInstrument(newInst);
            String[] oldInstStr = this.getInstrument(oldInst);
            return oldV + 10 * Integer.parseInt(oldInstStr[1]) + oldNote / 20 <= newV + 10 * Integer.parseInt(newInstStr[1]) + newNote / 20;
        }

        private String[] getInstrument(int x) {
            int priority = 0;
            String inst = "";
            switch (x + 1) {
                case 1: {
                    inst = "Acoustic Grand Piano";
                    priority = 10;
                    break;
                }
                case 2: {
                    inst = "Bright Acoustic Piano";
                    priority = 10;
                    break;
                }
                case 3: {
                    inst = "Electric Grand Piano";
                    priority = 8;
                    break;
                }
                case 4: {
                    inst = "Honky-tonk Piano";
                    priority = 4;
                    break;
                }
                case 5: {
                    inst = "Electric Piano 1";
                    priority = 6;
                    break;
                }
                case 6: {
                    inst = "Electric Piano 2";
                    priority = 6;
                    break;
                }
                case 7: {
                    inst = "Harpsichord";
                    priority = 7;
                    break;
                }
                case 8: {
                    inst = "Clavinet";
                    priority = 5;
                    break;
                }
                case 9: {
                    inst = "Celesta";
                    priority = 5;
                    break;
                }
                case 10: {
                    inst = "Glockenspiel";
                    priority = 2;
                    break;
                }
                case 11: {
                    inst = "Music Box";
                    priority = 3;
                    break;
                }
                case 12: {
                    inst = "Vibraphone";
                    priority = 4;
                    break;
                }
                case 13: {
                    inst = "Marimba";
                    priority = 3;
                    break;
                }
                case 14: {
                    inst = "Xylophone";
                    priority = 3;
                    break;
                }
                case 15: {
                    inst = "Tubular Bells";
                    priority = 4;
                    break;
                }
                case 16: {
                    inst = "Dulcimer";
                    priority = 3;
                    break;
                }
                case 17: {
                    inst = "Drawbar Organ";
                    priority = 7;
                    break;
                }
                case 18: {
                    inst = "Percussive Organ";
                    priority = 1;
                    break;
                }
                case 19: {
                    inst = "Rock Organ";
                    priority = 3;
                    break;
                }
                case 20: {
                    inst = "Church Organ";
                    priority = 6;
                    break;
                }
                case 21: {
                    inst = "Reed Organ";
                    priority = 5;
                    break;
                }
                case 22: {
                    inst = "Accordion";
                    priority = 4;
                    break;
                }
                case 23: {
                    inst = "Harmonica";
                    priority = 5;
                    break;
                }
                case 24: {
                    inst = "Tango Accordion";
                    priority = 5;
                    break;
                }
                case 25: {
                    inst = "Acoustic Guitar (nylon)";
                    priority = 6;
                    break;
                }
                case 26: {
                    inst = "Acoustic Guitar (steel)";
                    priority = 6;
                    break;
                }
                case 27: {
                    inst = "Electric Guitar (jazz)";
                    priority = 6;
                    break;
                }
                case 28: {
                    inst = "Electric Guitar (clean)";
                    priority = 6;
                    break;
                }
                case 29: {
                    inst = "Electric Guitar (muted)";
                    priority = 6;
                    break;
                }
                case 30: {
                    inst = "Overdriven Guitar";
                    priority = 7;
                    break;
                }
                case 31: {
                    inst = "Distortion Guitar";
                    priority = 6;
                    break;
                }
                case 32: {
                    inst = "Guitar harmonics";
                    priority = 6;
                    break;
                }
                case 33: {
                    inst = "Acoustic Bass";
                    priority = 4;
                    break;
                }
                case 34: {
                    inst = "Electric Bass(finger)";
                    priority = 4;
                    break;
                }
                case 35: {
                    inst = "Electric Bass(pick)";
                    priority = 4;
                    break;
                }
                case 36: {
                    inst = "Fretless Bass";
                    priority = 4;
                    break;
                }
                case 37: {
                    inst = "Slap Bass 1";
                    priority = 3;
                    break;
                }
                case 38: {
                    inst = "Slap Bass 2";
                    priority = 3;
                    break;
                }
                case 39: {
                    inst = "Synth Bass 1";
                    priority = 4;
                    break;
                }
                case 40: {
                    inst = "Synth Bass2";
                    priority = 4;
                    break;
                }
                case 41: {
                    inst = "Violin";
                    priority = 8;
                    break;
                }
                case 42: {
                    inst = "Viola";
                    priority = 7;
                    break;
                }
                case 43: {
                    inst = "Cello";
                    priority = 6;
                    break;
                }
                case 44: {
                    inst = "Contrabass";
                    priority = 6;
                    break;
                }
                case 45: {
                    inst = "Tremolo Strings";
                    priority = 7;
                    break;
                }
                case 46: {
                    inst = "Pizzicato Strings";
                    priority = 7;
                    break;
                }
                case 47: {
                    inst = "Orchestral Harp";
                    priority = 5;
                    break;
                }
                case 48: {
                    inst = "Timpani";
                    priority = 2;
                    break;
                }
                case 49: {
                    inst = "String Ensemble 1";
                    priority = 7;
                    break;
                }
                case 50: {
                    inst = "String Ensemble 2";
                    priority = 7;
                    break;
                }
                case 51: {
                    inst = "Synth Strings 1";
                    priority = 7;
                    break;
                }
                case 52: {
                    inst = "Synth Strings 2";
                    priority = 7;
                    break;
                }
                case 53: {
                    inst = "Choir Aahs";
                    priority = 5;
                    break;
                }
                case 54: {
                    inst = "Voice Oohs";
                    priority = 5;
                    break;
                }
                case 55: {
                    inst = "Synth Voice";
                    priority = 9;
                    break;
                }
                case 56: {
                    inst = "Orchestra Hit";
                    priority = 2;
                    break;
                }
                case 57: {
                    inst = "Trumpet";
                    priority = 7;
                    break;
                }
                case 58: {
                    inst = "Trombone";
                    priority = 6;
                    break;
                }
                case 59: {
                    inst = "Tuba";
                    priority = 4;
                    break;
                }
                case 60: {
                    inst = "Muted Trumpet";
                    priority = 6;
                    break;
                }
                case 61: {
                    inst = "FrenchbHorn";
                    priority = 7;
                    break;
                }
                case 62: {
                    inst = "Brass Section";
                    priority = 7;
                    break;
                }
                case 63: {
                    inst = "Synth Brass 1";
                    priority = 6;
                    break;
                }
                case 64: {
                    inst = "Synth Brass 2";
                    priority = 6;
                    break;
                }
                case 65: {
                    inst = "Soprano Sax";
                    priority = 5;
                    break;
                }
                case 66: {
                    inst = "Alto Sax";
                    priority = 6;
                    break;
                }
                case 67: {
                    inst = "Tenor Sax";
                    priority = 7;
                    break;
                }
                case 68: {
                    inst = "Baritone Sax";
                    priority = 4;
                    break;
                }
                case 69: {
                    inst = "Oboe";
                    priority = 8;
                    break;
                }
                case 70: {
                    inst = "English Horn";
                    priority = 7;
                    break;
                }
                case 71: {
                    inst = "Bassoon";
                    priority = 5;
                    break;
                }
                case 72: {
                    inst = "Clarinet";
                    priority = 8;
                    break;
                }
                case 73: {
                    inst = "Piccolo";
                    priority = 5;
                    break;
                }
                case 74: {
                    inst = "Flute";
                    priority = 7;
                    break;
                }
                case 75: {
                    inst = "Recorder";
                    priority = 4;
                    break;
                }
                case 76: {
                    inst = "Pan Flute";
                    priority = 4;
                    break;
                }
                case 77: {
                    inst = "Blown Bottle";
                    break;
                }
                case 78: {
                    inst = "Shakuhachi";
                    priority = 1;
                    break;
                }
                case 79: {
                    inst = "Whistle";
                    break;
                }
                case 80: {
                    inst = "Ocarina";
                    priority = 3;
                    break;
                }
                case 81: {
                    inst = "Lead 1 (square)";
                    priority = 9;
                    break;
                }
                case 82: {
                    inst = "Lead 2 (sawtooth)";
                    priority = 9;
                    break;
                }
                case 83: {
                    inst = "Lead 3 (calliope)";
                    priority = 9;
                    break;
                }
                case 84: {
                    inst = "Lead 4 (chiff)";
                    priority = 9;
                    break;
                }
                case 85: {
                    inst = "Lead 5 (charang)";
                    priority = 9;
                    break;
                }
                case 86: {
                    inst = "Lead 6 (voice)";
                    priority = 9;
                    break;
                }
                case 87: {
                    inst = "Lead 7 (fifths)";
                    priority = 9;
                    break;
                }
                case 88: {
                    inst = "Lead 8 (bass + lead)";
                    priority = 9;
                    break;
                }
                case 89: {
                    inst = "Pad 1 (new age)";
                    priority = 5;
                    break;
                }
                case 90: {
                    inst = "Pad 2 (warm)";
                    priority = 5;
                    break;
                }
                case 91: {
                    inst = "Pad 3 (polysynth)";
                    priority = 5;
                    break;
                }
                case 92: {
                    inst = "Pad 4 (choir)";
                    priority = 6;
                    break;
                }
                case 93: {
                    inst = "Pad 5 (bowed)";
                    priority = 6;
                    break;
                }
                case 94: {
                    inst = "Pad 6 (metallic)";
                    priority = 5;
                    break;
                }
                case 95: {
                    inst = "Pad 7 (halo)";
                    priority = 5;
                    break;
                }
                case 96: {
                    inst = "Pad 8 (sweep)";
                    priority = 5;
                    break;
                }
                case 97: {
                    inst = "FX1 (rain)";
                    break;
                }
                case 98: {
                    inst = "FX2 (soundtrack)";
                    break;
                }
                case 99: {
                    inst = "FX3 (crystal)";
                    break;
                }
                case 100: {
                    inst = "FX4 (atmosphere)";
                    break;
                }
                case 101: {
                    inst = "FX5 (brightness)";
                    break;
                }
                case 102: {
                    inst = "FX6 (goblins)";
                    break;
                }
                case 103: {
                    inst = "FX7 (echoes)";
                    break;
                }
                case 104: {
                    inst = "FX8 (sci-fi)";
                    break;
                }
                case 105: {
                    inst = "Sitar";
                    priority = 4;
                    break;
                }
                case 106: {
                    inst = "Banjo";
                    priority = 4;
                    break;
                }
                case 107: {
                    inst = "Shamisen";
                    priority = 3;
                    break;
                }
                case 108: {
                    inst = "Koto";
                    priority = 2;
                    break;
                }
                case 109: {
                    inst = "Kalimba";
                    priority = 1;
                    break;
                }
                case 110: {
                    inst = "Bagpipe";
                    priority = 6;
                    break;
                }
                case 111: {
                    inst = "Fiddle";
                    priority = 7;
                    break;
                }
                case 112: {
                    inst = "Shanai";
                    priority = 2;
                    break;
                }
                case 113: {
                    inst = "Tinkle Bell";
                    priority = 1;
                    break;
                }
                case 114: {
                    inst = "Agogo";
                    priority = 1;
                    break;
                }
                case 115: {
                    inst = "Steel Drums";
                    priority = 1;
                    break;
                }
                case 116: {
                    inst = "Wood block";
                    priority = 3;
                    break;
                }
                case 117: {
                    inst = "Taiko Drum";
                    priority = 1;
                    break;
                }
                case 118: {
                    inst = "Melodic Tom";
                    priority = 2;
                    break;
                }
                case 119: {
                    inst = "Synth Drum";
                    priority = 1;
                    break;
                }
                case 120: {
                    inst = "Reverse Cymbal";
                    priority = 1;
                    break;
                }
                case 121: {
                    inst = "Guitar Fret Noise";
                    break;
                }
                case 122: {
                    inst = "Breath Noise";
                    break;
                }
                case 123: {
                    inst = "Seashore";
                    break;
                }
                case 124: {
                    inst = "Bird Tweet";
                    break;
                }
                case 125: {
                    inst = "Telephone Ring";
                    break;
                }
                case 126: {
                    inst = "Helicopter";
                    break;
                }
                case 127: {
                    inst = "Applause";
                    break;
                }
                case 128: {
                    inst = "Gunshot";
                }
            }
            return new String[]{inst, Integer.toString(priority)};
        }
    }

    private class WAVConverterThread
    implements Runnable {
        private WAVConverterThread() {
        }

        public void run() {
            songConverter.this.generateScoreFromWav(inFile);
        }
    }
}

